package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerDetails(
    availabilityZones: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    backendServerDescriptions: Optional[Iterable[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription
    ]] = Optional.Absent,
    canonicalHostedZoneName: Optional[NonEmptyString] = Optional.Absent,
    canonicalHostedZoneNameID: Optional[NonEmptyString] = Optional.Absent,
    createdTime: Optional[NonEmptyString] = Optional.Absent,
    dnsName: Optional[NonEmptyString] = Optional.Absent,
    healthCheck: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck
    ] = Optional.Absent,
    instances: Optional[
      Iterable[zio.aws.securityhub.model.AwsElbLoadBalancerInstance]
    ] = Optional.Absent,
    listenerDescriptions: Optional[
      Iterable[zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription]
    ] = Optional.Absent,
    loadBalancerAttributes: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes
    ] = Optional.Absent,
    loadBalancerName: Optional[NonEmptyString] = Optional.Absent,
    policies: Optional[zio.aws.securityhub.model.AwsElbLoadBalancerPolicies] =
      Optional.Absent,
    scheme: Optional[NonEmptyString] = Optional.Absent,
    securityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    sourceSecurityGroup: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
    ] = Optional.Absent,
    subnets: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails = {
    import AwsElbLoadBalancerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backendServerDescriptions)
      .optionallyWith(
        canonicalHostedZoneName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneName)
      .optionallyWith(
        canonicalHostedZoneNameID.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneNameID)
      .optionallyWith(
        createdTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdTime)
      .optionallyWith(
        dnsName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        listenerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listenerDescriptions)
      .optionallyWith(
        loadBalancerAttributes.map(value => value.buildAwsValue())
      )(_.loadBalancerAttributes)
      .optionallyWith(
        loadBalancerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(
        scheme.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scheme)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceSecurityGroup.map(value => value.buildAwsValue()))(
        _.sourceSecurityGroup
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerDetails.wrap(buildAwsValue())
}
object AwsElbLoadBalancerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerDetails =
      zio.aws.securityhub.model.AwsElbLoadBalancerDetails(
        availabilityZones.map(value => value),
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        canonicalHostedZoneName.map(value => value),
        canonicalHostedZoneNameID.map(value => value),
        createdTime.map(value => value),
        dnsName.map(value => value),
        healthCheck.map(value => value.asEditable),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        listenerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancerAttributes.map(value => value.asEditable),
        loadBalancerName.map(value => value),
        policies.map(value => value.asEditable),
        scheme.map(value => value),
        securityGroups.map(value => value),
        sourceSecurityGroup.map(value => value.asEditable),
        subnets.map(value => value),
        vpcId.map(value => value)
      )
    def availabilityZones: Optional[List[NonEmptyString]]
    def backendServerDescriptions: Optional[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly
    ]]
    def canonicalHostedZoneName: Optional[NonEmptyString]
    def canonicalHostedZoneNameID: Optional[NonEmptyString]
    def createdTime: Optional[NonEmptyString]
    def dnsName: Optional[NonEmptyString]
    def healthCheck: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly
    ]
    def instances: Optional[
      List[zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly]
    ]
    def listenerDescriptions: Optional[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly
    ]]
    def loadBalancerAttributes: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly
    ]
    def loadBalancerName: Optional[NonEmptyString]
    def policies: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly
    ]
    def scheme: Optional[NonEmptyString]
    def securityGroups: Optional[List[NonEmptyString]]
    def sourceSecurityGroup: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly
    ]
    def subnets: Optional[List[NonEmptyString]]
    def vpcId: Optional[NonEmptyString]
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackendServerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backendServerDescriptions",
      backendServerDescriptions
    )
    def getCanonicalHostedZoneName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "canonicalHostedZoneName",
        canonicalHostedZoneName
      )
    def getCanonicalHostedZoneNameID: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "canonicalHostedZoneNameID",
        canonicalHostedZoneNameID
      )
    def getCreatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getListenerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("listenerDescriptions", listenerDescriptions)
    def getLoadBalancerAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "loadBalancerAttributes",
      loadBalancerAttributes
    )
    def getLoadBalancerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getScheme: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scheme", scheme)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("sourceSecurityGroup", sourceSecurityGroup)
    def getSubnets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly {
    override val availabilityZones: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val backendServerDescriptions: Optional[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.backendServerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription
            .wrap(item)
        }.toList
      )
    override val canonicalHostedZoneName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canonicalHostedZoneName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val canonicalHostedZoneNameID: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canonicalHostedZoneNameID())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdTime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dnsName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val healthCheck: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheck())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.wrap(value)
      )
    override val instances: Optional[
      List[zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLoadBalancerInstance.wrap(item)
        }.toList
      )
    override val listenerDescriptions: Optional[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription
            .wrap(item)
        }.toList
      )
    override val loadBalancerAttributes: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerAttributes())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.wrap(value)
      )
    override val loadBalancerName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val policies: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.wrap(value)
      )
    override val scheme: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scheme())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val sourceSecurityGroup: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceSecurityGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
          .wrap(value)
      )
    override val subnets: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
  ): zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly = new Wrapper(
    impl
  )
}
