package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesDetails(
    dockerVolumeConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
    ] = Optional.Absent,
    efsVolumeConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
    ] = Optional.Absent,
    host: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails = {
    import AwsEcsTaskDefinitionVolumesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
      .builder()
      .optionallyWith(
        dockerVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.dockerVolumeConfiguration)
      .optionallyWith(
        efsVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.efsVolumeConfiguration)
      .optionallyWith(host.map(value => value.buildAwsValue()))(_.host)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails(
        dockerVolumeConfiguration.map(value => value.asEditable),
        efsVolumeConfiguration.map(value => value.asEditable),
        host.map(value => value.asEditable),
        name.map(value => value)
      )
    def dockerVolumeConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly
    ]
    def efsVolumeConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly
    ]
    def host: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly
    ]
    def name: Optional[NonEmptyString]
    def getDockerVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dockerVolumeConfiguration",
      dockerVolumeConfiguration
    )
    def getEfsVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "efsVolumeConfiguration",
      efsVolumeConfiguration
    )
    def getHost: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly
    ] = AwsError.unwrapOptionField("host", host)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly {
    override val dockerVolumeConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dockerVolumeConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
          .wrap(value)
      )
    override val efsVolumeConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.efsVolumeConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
          .wrap(value)
      )
    override val host: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
          .wrap(value)
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly =
    new Wrapper(impl)
}
