package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionOptionsTunnelOptionsDetails(
    dpdTimeoutSeconds: Optional[Integer] = Optional.Absent,
    ikeVersions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    outsideIpAddress: Optional[NonEmptyString] = Optional.Absent,
    phase1DhGroupNumbers: Optional[Iterable[Integer]] = Optional.Absent,
    phase1EncryptionAlgorithms: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    phase1IntegrityAlgorithms: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    phase1LifetimeSeconds: Optional[Integer] = Optional.Absent,
    phase2DhGroupNumbers: Optional[Iterable[Integer]] = Optional.Absent,
    phase2EncryptionAlgorithms: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    phase2IntegrityAlgorithms: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    phase2LifetimeSeconds: Optional[Integer] = Optional.Absent,
    preSharedKey: Optional[NonEmptyString] = Optional.Absent,
    rekeyFuzzPercentage: Optional[Integer] = Optional.Absent,
    rekeyMarginTimeSeconds: Optional[Integer] = Optional.Absent,
    replayWindowSize: Optional[Integer] = Optional.Absent,
    tunnelInsideCidr: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails = {
    import AwsEc2VpnConnectionOptionsTunnelOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
      .builder()
      .optionallyWith(dpdTimeoutSeconds.map(value => value: java.lang.Integer))(
        _.dpdTimeoutSeconds
      )
      .optionallyWith(
        ikeVersions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ikeVersions)
      .optionallyWith(
        outsideIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.outsideIpAddress)
      .optionallyWith(
        phase1DhGroupNumbers.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.phase1DhGroupNumbers)
      .optionallyWith(
        phase1EncryptionAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase1EncryptionAlgorithms)
      .optionallyWith(
        phase1IntegrityAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase1IntegrityAlgorithms)
      .optionallyWith(
        phase1LifetimeSeconds.map(value => value: java.lang.Integer)
      )(_.phase1LifetimeSeconds)
      .optionallyWith(
        phase2DhGroupNumbers.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.phase2DhGroupNumbers)
      .optionallyWith(
        phase2EncryptionAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase2EncryptionAlgorithms)
      .optionallyWith(
        phase2IntegrityAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase2IntegrityAlgorithms)
      .optionallyWith(
        phase2LifetimeSeconds.map(value => value: java.lang.Integer)
      )(_.phase2LifetimeSeconds)
      .optionallyWith(
        preSharedKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preSharedKey)
      .optionallyWith(
        rekeyFuzzPercentage.map(value => value: java.lang.Integer)
      )(_.rekeyFuzzPercentage)
      .optionallyWith(
        rekeyMarginTimeSeconds.map(value => value: java.lang.Integer)
      )(_.rekeyMarginTimeSeconds)
      .optionallyWith(replayWindowSize.map(value => value: java.lang.Integer))(
        _.replayWindowSize
      )
      .optionallyWith(
        tunnelInsideCidr.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tunnelInsideCidr)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails(
        dpdTimeoutSeconds.map(value => value),
        ikeVersions.map(value => value),
        outsideIpAddress.map(value => value),
        phase1DhGroupNumbers.map(value => value),
        phase1EncryptionAlgorithms.map(value => value),
        phase1IntegrityAlgorithms.map(value => value),
        phase1LifetimeSeconds.map(value => value),
        phase2DhGroupNumbers.map(value => value),
        phase2EncryptionAlgorithms.map(value => value),
        phase2IntegrityAlgorithms.map(value => value),
        phase2LifetimeSeconds.map(value => value),
        preSharedKey.map(value => value),
        rekeyFuzzPercentage.map(value => value),
        rekeyMarginTimeSeconds.map(value => value),
        replayWindowSize.map(value => value),
        tunnelInsideCidr.map(value => value)
      )
    def dpdTimeoutSeconds: Optional[Integer]
    def ikeVersions: Optional[List[NonEmptyString]]
    def outsideIpAddress: Optional[NonEmptyString]
    def phase1DhGroupNumbers: Optional[List[Integer]]
    def phase1EncryptionAlgorithms: Optional[List[NonEmptyString]]
    def phase1IntegrityAlgorithms: Optional[List[NonEmptyString]]
    def phase1LifetimeSeconds: Optional[Integer]
    def phase2DhGroupNumbers: Optional[List[Integer]]
    def phase2EncryptionAlgorithms: Optional[List[NonEmptyString]]
    def phase2IntegrityAlgorithms: Optional[List[NonEmptyString]]
    def phase2LifetimeSeconds: Optional[Integer]
    def preSharedKey: Optional[NonEmptyString]
    def rekeyFuzzPercentage: Optional[Integer]
    def rekeyMarginTimeSeconds: Optional[Integer]
    def replayWindowSize: Optional[Integer]
    def tunnelInsideCidr: Optional[NonEmptyString]
    def getDpdTimeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dpdTimeoutSeconds", dpdTimeoutSeconds)
    def getIkeVersions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ikeVersions", ikeVersions)
    def getOutsideIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getPhase1DhGroupNumbers: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("phase1DhGroupNumbers", phase1DhGroupNumbers)
    def getPhase1EncryptionAlgorithms
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "phase1EncryptionAlgorithms",
      phase1EncryptionAlgorithms
    )
    def getPhase1IntegrityAlgorithms: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "phase1IntegrityAlgorithms",
        phase1IntegrityAlgorithms
      )
    def getPhase1LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase1LifetimeSeconds", phase1LifetimeSeconds)
    def getPhase2DhGroupNumbers: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("phase2DhGroupNumbers", phase2DhGroupNumbers)
    def getPhase2EncryptionAlgorithms
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "phase2EncryptionAlgorithms",
      phase2EncryptionAlgorithms
    )
    def getPhase2IntegrityAlgorithms: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "phase2IntegrityAlgorithms",
        phase2IntegrityAlgorithms
      )
    def getPhase2LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase2LifetimeSeconds", phase2LifetimeSeconds)
    def getPreSharedKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preSharedKey", preSharedKey)
    def getRekeyFuzzPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("rekeyFuzzPercentage", rekeyFuzzPercentage)
    def getRekeyMarginTimeSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("rekeyMarginTimeSeconds", rekeyMarginTimeSeconds)
    def getReplayWindowSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("replayWindowSize", replayWindowSize)
    def getTunnelInsideCidr: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tunnelInsideCidr", tunnelInsideCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly {
    override val dpdTimeoutSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dpdTimeoutSeconds())
      .map(value => value: Integer)
    override val ikeVersions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ikeVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val outsideIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outsideIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val phase1DhGroupNumbers: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase1DhGroupNumbers())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
    override val phase1EncryptionAlgorithms: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase1EncryptionAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val phase1IntegrityAlgorithms: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase1IntegrityAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val phase1LifetimeSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase1LifetimeSeconds())
        .map(value => value: Integer)
    override val phase2DhGroupNumbers: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase2DhGroupNumbers())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
    override val phase2EncryptionAlgorithms: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase2EncryptionAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val phase2IntegrityAlgorithms: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase2IntegrityAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val phase2LifetimeSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase2LifetimeSeconds())
        .map(value => value: Integer)
    override val preSharedKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.preSharedKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rekeyFuzzPercentage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.rekeyFuzzPercentage())
      .map(value => value: Integer)
    override val rekeyMarginTimeSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rekeyMarginTimeSeconds())
        .map(value => value: Integer)
    override val replayWindowSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.replayWindowSize())
      .map(value => value: Integer)
    override val tunnelInsideCidr: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tunnelInsideCidr())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
