package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpcEndpointServiceServiceTypeDetails(
    serviceType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails = {
    import AwsEc2VpcEndpointServiceServiceTypeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
      .builder()
      .optionallyWith(
        serviceType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpcEndpointServiceServiceTypeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails =
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails(
        serviceType.map(value => value)
      )
    def serviceType: Optional[NonEmptyString]
    def getServiceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails.ReadOnly {
    override val serviceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
  ): zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails.ReadOnly =
    new Wrapper(impl)
}
