package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupPrefixListId(
    prefixListId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListId = {
    import AwsEc2SecurityGroupPrefixListId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListId
      .builder()
      .optionallyWith(
        prefixListId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId
      .wrap(buildAwsValue())
}
object AwsEc2SecurityGroupPrefixListId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId =
      zio.aws.securityhub.model
        .AwsEc2SecurityGroupPrefixListId(prefixListId.map(value => value))
    def prefixListId: Optional[NonEmptyString]
    def getPrefixListId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListId
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly {
    override val prefixListId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupPrefixListId
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly =
    new Wrapper(impl)
}
