package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupDetails(
    groupName: Optional[NonEmptyString] = Optional.Absent,
    groupId: Optional[NonEmptyString] = Optional.Absent,
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    ipPermissions: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission]
    ] = Optional.Absent,
    ipPermissionsEgress: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails = {
    import AwsEc2SecurityGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissionsEgress)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.wrap(buildAwsValue())
}
object AwsEc2SecurityGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupDetails =
      zio.aws.securityhub.model.AwsEc2SecurityGroupDetails(
        groupName.map(value => value),
        groupId.map(value => value),
        ownerId.map(value => value),
        vpcId.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupName: Optional[NonEmptyString]
    def groupId: Optional[NonEmptyString]
    def ownerId: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def ipPermissions: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ]
    def ipPermissionsEgress: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getIpPermissions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getIpPermissionsEgress: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("ipPermissionsEgress", ipPermissionsEgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly {
    override val groupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipPermissions: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.wrap(item)
        }.toList
      )
    override val ipPermissionsEgress: Optional[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipPermissionsEgress())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly =
    new Wrapper(impl)
}
