package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableProjection(
    nonKeyAttributes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    projectionType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection = {
    import AwsDynamoDbTableProjection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection
      .builder()
      .optionallyWith(
        nonKeyAttributes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nonKeyAttributes)
      .optionallyWith(
        projectionType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.projectionType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableProjection.wrap(buildAwsValue())
}
object AwsDynamoDbTableProjection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableProjection =
      zio.aws.securityhub.model.AwsDynamoDbTableProjection(
        nonKeyAttributes.map(value => value),
        projectionType.map(value => value)
      )
    def nonKeyAttributes: Optional[List[NonEmptyString]]
    def projectionType: Optional[NonEmptyString]
    def getNonKeyAttributes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("nonKeyAttributes", nonKeyAttributes)
    def getProjectionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectionType", projectionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly {
    override val nonKeyAttributes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonKeyAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val projectionType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectionType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection
  ): zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly =
    new Wrapper(impl)
}
