package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectDetails(
    encryptionKey: Optional[NonEmptyString] = Optional.Absent,
    artifacts: Optional[
      Iterable[zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails]
    ] = Optional.Absent,
    environment: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    source: Optional[zio.aws.securityhub.model.AwsCodeBuildProjectSource] =
      Optional.Absent,
    serviceRole: Optional[NonEmptyString] = Optional.Absent,
    logsConfig: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
    ] = Optional.Absent,
    vpcConfig: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig
    ] = Optional.Absent,
    secondaryArtifacts: Optional[
      Iterable[zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails = {
    import AwsCodeBuildProjectDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
      .builder()
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        artifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifacts)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(logsConfig.map(value => value.buildAwsValue()))(
        _.logsConfig
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectDetails.wrap(buildAwsValue())
}
object AwsCodeBuildProjectDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCodeBuildProjectDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectDetails(
        encryptionKey.map(value => value),
        artifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environment.map(value => value.asEditable),
        name.map(value => value),
        source.map(value => value.asEditable),
        serviceRole.map(value => value),
        logsConfig.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def encryptionKey: Optional[NonEmptyString]
    def artifacts: Optional[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]]
    def environment: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly
    ]
    def name: Optional[NonEmptyString]
    def source
        : Optional[zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly]
    def serviceRole: Optional[NonEmptyString]
    def logsConfig: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly
    ]
    def vpcConfig: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.ReadOnly
    ]
    def secondaryArtifacts: Optional[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]]
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getArtifacts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getLogsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logsConfig", logsConfig)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly {
    override val encryptionKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val artifacts: Optional[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.artifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails
            .wrap(item)
        }.toList
      )
    override val environment: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environment())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.wrap(value)
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val source: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectSource.wrap(value)
      )
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logsConfig: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logsConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
          .wrap(value)
      )
    override val vpcConfig: Optional[
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.wrap(value)
      )
    override val secondaryArtifacts: Optional[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.secondaryArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly =
    new Wrapper(impl)
}
