package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginItem(
    domainName: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    originPath: Optional[NonEmptyString] = Optional.Absent,
    s3OriginConfig: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem = {
    import AwsCloudFrontDistributionOriginItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
      .builder()
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        originPath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.originPath)
      .optionallyWith(s3OriginConfig.map(value => value.buildAwsValue()))(
        _.s3OriginConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem(
        domainName.map(value => value),
        id.map(value => value),
        originPath.map(value => value),
        s3OriginConfig.map(value => value.asEditable)
      )
    def domainName: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def originPath: Optional[NonEmptyString]
    def s3OriginConfig: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly
    ]
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getOriginPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originPath", originPath)
    def getS3OriginConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3OriginConfig", s3OriginConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly {
    override val domainName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val originPath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.originPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3OriginConfig: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OriginConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly =
    new Wrapper(impl)
}
