package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionLogging(
    bucket: Optional[NonEmptyString] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    includeCookies: Optional[Boolean] = Optional.Absent,
    prefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionLogging = {
    import AwsCloudFrontDistributionLogging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionLogging
      .builder()
      .optionallyWith(
        bucket.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(includeCookies.map(value => value: java.lang.Boolean))(
        _.includeCookies
      )
      .optionallyWith(
        prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionLogging
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionLogging {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionLogging
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudFrontDistributionLogging =
      zio.aws.securityhub.model.AwsCloudFrontDistributionLogging(
        bucket.map(value => value),
        enabled.map(value => value),
        includeCookies.map(value => value),
        prefix.map(value => value)
      )
    def bucket: Optional[NonEmptyString]
    def enabled: Optional[Boolean]
    def includeCookies: Optional[Boolean]
    def prefix: Optional[NonEmptyString]
    def getBucket: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIncludeCookies: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeCookies", includeCookies)
    def getPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionLogging
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.ReadOnly {
    override val bucket: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val includeCookies: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeCookies())
      .map(value => value: Boolean)
    override val prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionLogging
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.ReadOnly =
    new Wrapper(impl)
}
