package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateResourceRecord(
    name: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord = {
    import AwsCertificateManagerCertificateResourceRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateResourceRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord =
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord(
        name.map(value => value),
        `type`.map(value => value),
        value.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly =
    new Wrapper(impl)
}
