package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification(
    launchTemplateId: Optional[NonEmptyString] = Optional.Absent,
    launchTemplateName: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification(
          launchTemplateId.map(value => value),
          launchTemplateName.map(value => value),
          version.map(value => value)
        )
    def launchTemplateId: Optional[NonEmptyString]
    def launchTemplateName: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def getLaunchTemplateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly {
    override val launchTemplateId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val launchTemplateName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly =
    new Wrapper(impl)
}
