package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiCallAction(
    api: Optional[NonEmptyString] = Optional.Absent,
    serviceName: Optional[NonEmptyString] = Optional.Absent,
    callerType: Optional[NonEmptyString] = Optional.Absent,
    remoteIpDetails: Optional[zio.aws.securityhub.model.ActionRemoteIpDetails] =
      Optional.Absent,
    domainDetails: Optional[
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails
    ] = Optional.Absent,
    affectedResources: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    firstSeen: Optional[NonEmptyString] = Optional.Absent,
    lastSeen: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiCallAction = {
    import AwsApiCallAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
      .builder()
      .optionallyWith(
        api.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.api)
      .optionallyWith(
        serviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        callerType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.callerType)
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .optionallyWith(domainDetails.map(value => value.buildAwsValue()))(
        _.domainDetails
      )
      .optionallyWith(
        affectedResources.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.affectedResources)
      .optionallyWith(
        firstSeen.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.firstSeen)
      .optionallyWith(
        lastSeen.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.lastSeen)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsApiCallAction.ReadOnly =
    zio.aws.securityhub.model.AwsApiCallAction.wrap(buildAwsValue())
}
object AwsApiCallAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiCallAction =
      zio.aws.securityhub.model.AwsApiCallAction(
        api.map(value => value),
        serviceName.map(value => value),
        callerType.map(value => value),
        remoteIpDetails.map(value => value.asEditable),
        domainDetails.map(value => value.asEditable),
        affectedResources.map(value => value),
        firstSeen.map(value => value),
        lastSeen.map(value => value)
      )
    def api: Optional[NonEmptyString]
    def serviceName: Optional[NonEmptyString]
    def callerType: Optional[NonEmptyString]
    def remoteIpDetails
        : Optional[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly]
    def domainDetails: Optional[
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly
    ]
    def affectedResources: Optional[Map[NonEmptyString, NonEmptyString]]
    def firstSeen: Optional[NonEmptyString]
    def lastSeen: Optional[NonEmptyString]
    def getApi: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("api", api)
    def getServiceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getCallerType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("callerType", callerType)
    def getRemoteIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
    def getDomainDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly
    ] = AwsError.unwrapOptionField("domainDetails", domainDetails)
    def getAffectedResources
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("affectedResources", affectedResources)
    def getFirstSeen: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firstSeen", firstSeen)
    def getLastSeen: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastSeen", lastSeen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
  ) extends zio.aws.securityhub.model.AwsApiCallAction.ReadOnly {
    override val api: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.api())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val callerType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.callerType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val remoteIpDetails
        : Optional[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(value)
        )
    override val domainDetails: Optional[
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainDetails())
      .map(value =>
        zio.aws.securityhub.model.AwsApiCallActionDomainDetails.wrap(value)
      )
    override val affectedResources
        : Optional[Map[NonEmptyString, NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.affectedResources())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val firstSeen: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.firstSeen())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastSeen: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeen())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
  ): zio.aws.securityhub.model.AwsApiCallAction.ReadOnly = new Wrapper(impl)
}
