package zio.aws.securityhub
import zio.aws.securityhub.model.DisassociateMembersResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient
import zio.aws.securityhub.model.{
  CreateFindingAggregatorRequest,
  InviteMembersRequest,
  GetEnabledStandardsRequest,
  EnableOrganizationAdminAccountRequest,
  DisableOrganizationAdminAccountRequest,
  BatchUpdateFindingsRequest,
  DeleteActionTargetRequest,
  DisableSecurityHubRequest,
  EnableSecurityHubRequest,
  DeleteInvitationsRequest,
  DescribeProductsRequest,
  CreateActionTargetRequest,
  GetInsightsRequest,
  GetMembersRequest,
  ListMembersRequest,
  DescribeStandardsControlsRequest,
  UpdateStandardsControlRequest,
  DescribeActionTargetsRequest,
  BatchEnableStandardsRequest,
  BatchImportFindingsRequest,
  ListTagsForResourceRequest,
  GetFindingsRequest,
  UpdateFindingAggregatorRequest,
  DeleteInsightRequest,
  CreateMembersRequest,
  GetAdministratorAccountRequest,
  DescribeStandardsRequest,
  ListFindingAggregatorsRequest,
  DeclineInvitationsRequest,
  ListOrganizationAdminAccountsRequest,
  UpdateOrganizationConfigurationRequest,
  GetFindingAggregatorRequest,
  ListInvitationsRequest,
  UpdateInsightRequest,
  BatchDisableStandardsRequest,
  DescribeHubRequest,
  UntagResourceRequest,
  ListEnabledProductsForImportRequest,
  EnableImportFindingsForProductRequest,
  DisableImportFindingsForProductRequest,
  AcceptAdministratorInvitationRequest,
  UpdateActionTargetRequest,
  GetInsightResultsRequest,
  DeleteMembersRequest,
  DeleteFindingAggregatorRequest,
  DescribeOrganizationConfigurationRequest,
  UpdateFindingsRequest,
  GetInvitationsCountRequest,
  CreateInsightRequest,
  UpdateSecurityHubConfigurationRequest,
  DisassociateFromAdministratorAccountRequest,
  TagResourceRequest,
  DisassociateMembersRequest
}
import zio.aws.core.AwsError
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SecurityHubMock extends Mock[SecurityHub] {
  object GetAdministratorAccount
      extends Effect[
        GetAdministratorAccountRequest,
        AwsError,
        zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly
      ]
  object BatchEnableStandards
      extends Effect[
        BatchEnableStandardsRequest,
        AwsError,
        zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly
      ]
  object DisableOrganizationAdminAccount
      extends Effect[
        DisableOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.securityhub.model.DisableOrganizationAdminAccountResponse.ReadOnly
      ]
  object GetInsights
      extends Stream[
        GetInsightsRequest,
        AwsError,
        zio.aws.securityhub.model.Insight.ReadOnly
      ]
  object GetInsightsPaginated
      extends Effect[
        GetInsightsRequest,
        AwsError,
        zio.aws.securityhub.model.GetInsightsResponse.ReadOnly
      ]
  object ListOrganizationAdminAccounts
      extends Stream[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.securityhub.model.AdminAccount.ReadOnly
      ]
  object ListOrganizationAdminAccountsPaginated
      extends Effect[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly
      ]
  object UpdateFindingAggregator
      extends Effect[
        UpdateFindingAggregatorRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly
      ]
  object UpdateOrganizationConfiguration
      extends Effect[
        UpdateOrganizationConfigurationRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateOrganizationConfigurationResponse.ReadOnly
      ]
  object DisableImportFindingsForProduct
      extends Effect[
        DisableImportFindingsForProductRequest,
        AwsError,
        zio.aws.securityhub.model.DisableImportFindingsForProductResponse.ReadOnly
      ]
  object GetInvitationsCount
      extends Effect[
        GetInvitationsCountRequest,
        AwsError,
        zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly
      ]
  object BatchUpdateFindings
      extends Effect[
        BatchUpdateFindingsRequest,
        AwsError,
        zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly
      ]
  object UpdateActionTarget
      extends Effect[
        UpdateActionTargetRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateActionTargetResponse.ReadOnly
      ]
  object DescribeStandards
      extends Stream[
        DescribeStandardsRequest,
        AwsError,
        zio.aws.securityhub.model.Standard.ReadOnly
      ]
  object DescribeStandardsPaginated
      extends Effect[
        DescribeStandardsRequest,
        AwsError,
        zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly
      ]
  object DisassociateMembers
      extends Effect[DisassociateMembersRequest, AwsError, ReadOnly]
  object BatchDisableStandards
      extends Effect[
        BatchDisableStandardsRequest,
        AwsError,
        zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly
      ]
  object DeleteInsight
      extends Effect[
        DeleteInsightRequest,
        AwsError,
        zio.aws.securityhub.model.DeleteInsightResponse.ReadOnly
      ]
  object ListMembers
      extends Stream[
        ListMembersRequest,
        AwsError,
        zio.aws.securityhub.model.Member.ReadOnly
      ]
  object ListMembersPaginated
      extends Effect[
        ListMembersRequest,
        AwsError,
        zio.aws.securityhub.model.ListMembersResponse.ReadOnly
      ]
  object EnableImportFindingsForProduct
      extends Effect[
        EnableImportFindingsForProductRequest,
        AwsError,
        zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly
      ]
  object DescribeProducts
      extends Stream[
        DescribeProductsRequest,
        AwsError,
        zio.aws.securityhub.model.Product.ReadOnly
      ]
  object DescribeProductsPaginated
      extends Effect[
        DescribeProductsRequest,
        AwsError,
        zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly
      ]
  object CreateFindingAggregator
      extends Effect[
        CreateFindingAggregatorRequest,
        AwsError,
        zio.aws.securityhub.model.CreateFindingAggregatorResponse.ReadOnly
      ]
  object ListEnabledProductsForImport
      extends Stream[
        ListEnabledProductsForImportRequest,
        AwsError,
        NonEmptyString
      ]
  object ListEnabledProductsForImportPaginated
      extends Effect[
        ListEnabledProductsForImportRequest,
        AwsError,
        zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly
      ]
  object InviteMembers
      extends Effect[
        InviteMembersRequest,
        AwsError,
        zio.aws.securityhub.model.InviteMembersResponse.ReadOnly
      ]
  object AcceptAdministratorInvitation
      extends Effect[
        AcceptAdministratorInvitationRequest,
        AwsError,
        zio.aws.securityhub.model.AcceptAdministratorInvitationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.securityhub.model.UntagResourceResponse.ReadOnly
      ]
  object GetFindings
      extends Stream[
        GetFindingsRequest,
        AwsError,
        zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
      ]
  object GetFindingsPaginated
      extends Effect[
        GetFindingsRequest,
        AwsError,
        zio.aws.securityhub.model.GetFindingsResponse.ReadOnly
      ]
  object UpdateFindings
      extends Effect[
        UpdateFindingsRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateFindingsResponse.ReadOnly
      ]
  object CreateMembers
      extends Effect[
        CreateMembersRequest,
        AwsError,
        zio.aws.securityhub.model.CreateMembersResponse.ReadOnly
      ]
  object DescribeOrganizationConfiguration
      extends Effect[
        DescribeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly
      ]
  object CreateActionTarget
      extends Effect[
        CreateActionTargetRequest,
        AwsError,
        zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly
      ]
  object CreateInsight
      extends Effect[
        CreateInsightRequest,
        AwsError,
        zio.aws.securityhub.model.CreateInsightResponse.ReadOnly
      ]
  object DescribeActionTargets
      extends Stream[
        DescribeActionTargetsRequest,
        AwsError,
        zio.aws.securityhub.model.ActionTarget.ReadOnly
      ]
  object DescribeActionTargetsPaginated
      extends Effect[
        DescribeActionTargetsRequest,
        AwsError,
        zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly
      ]
  object EnableSecurityHub
      extends Effect[
        EnableSecurityHubRequest,
        AwsError,
        zio.aws.securityhub.model.EnableSecurityHubResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.securityhub.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.securityhub.model.TagResourceResponse.ReadOnly
      ]
  object UpdateStandardsControl
      extends Effect[
        UpdateStandardsControlRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateStandardsControlResponse.ReadOnly
      ]
  object ListFindingAggregators
      extends Stream[
        ListFindingAggregatorsRequest,
        AwsError,
        zio.aws.securityhub.model.FindingAggregator.ReadOnly
      ]
  object ListFindingAggregatorsPaginated
      extends Effect[
        ListFindingAggregatorsRequest,
        AwsError,
        zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly
      ]
  object DisableSecurityHub
      extends Effect[
        DisableSecurityHubRequest,
        AwsError,
        zio.aws.securityhub.model.DisableSecurityHubResponse.ReadOnly
      ]
  object ListInvitations
      extends Stream[
        ListInvitationsRequest,
        AwsError,
        zio.aws.securityhub.model.Invitation.ReadOnly
      ]
  object ListInvitationsPaginated
      extends Effect[
        ListInvitationsRequest,
        AwsError,
        zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly
      ]
  object DeclineInvitations
      extends Effect[
        DeclineInvitationsRequest,
        AwsError,
        zio.aws.securityhub.model.DeclineInvitationsResponse.ReadOnly
      ]
  object GetInsightResults
      extends Effect[
        GetInsightResultsRequest,
        AwsError,
        zio.aws.securityhub.model.GetInsightResultsResponse.ReadOnly
      ]
  object DeleteFindingAggregator
      extends Effect[
        DeleteFindingAggregatorRequest,
        AwsError,
        zio.aws.securityhub.model.DeleteFindingAggregatorResponse.ReadOnly
      ]
  object DescribeStandardsControls
      extends Stream[
        DescribeStandardsControlsRequest,
        AwsError,
        zio.aws.securityhub.model.StandardsControl.ReadOnly
      ]
  object DescribeStandardsControlsPaginated
      extends Effect[
        DescribeStandardsControlsRequest,
        AwsError,
        zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly
      ]
  object GetFindingAggregator
      extends Effect[
        GetFindingAggregatorRequest,
        AwsError,
        zio.aws.securityhub.model.GetFindingAggregatorResponse.ReadOnly
      ]
  object DescribeHub
      extends Effect[
        DescribeHubRequest,
        AwsError,
        zio.aws.securityhub.model.DescribeHubResponse.ReadOnly
      ]
  object EnableOrganizationAdminAccount
      extends Effect[
        EnableOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.securityhub.model.EnableOrganizationAdminAccountResponse.ReadOnly
      ]
  object DeleteInvitations
      extends Effect[
        DeleteInvitationsRequest,
        AwsError,
        zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly
      ]
  object BatchImportFindings
      extends Effect[
        BatchImportFindingsRequest,
        AwsError,
        zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly
      ]
  object GetEnabledStandards
      extends Stream[
        GetEnabledStandardsRequest,
        AwsError,
        zio.aws.securityhub.model.StandardsSubscription.ReadOnly
      ]
  object GetEnabledStandardsPaginated
      extends Effect[
        GetEnabledStandardsRequest,
        AwsError,
        zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly
      ]
  object UpdateSecurityHubConfiguration
      extends Effect[
        UpdateSecurityHubConfigurationRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateSecurityHubConfigurationResponse.ReadOnly
      ]
  object DeleteMembers
      extends Effect[
        DeleteMembersRequest,
        AwsError,
        zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly
      ]
  object DisassociateFromAdministratorAccount
      extends Effect[
        DisassociateFromAdministratorAccountRequest,
        AwsError,
        zio.aws.securityhub.model.DisassociateFromAdministratorAccountResponse.ReadOnly
      ]
  object DeleteActionTarget
      extends Effect[
        DeleteActionTargetRequest,
        AwsError,
        zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly
      ]
  object GetMembers
      extends Effect[
        GetMembersRequest,
        AwsError,
        zio.aws.securityhub.model.GetMembersResponse.ReadOnly
      ]
  object UpdateInsight
      extends Effect[
        UpdateInsightRequest,
        AwsError,
        zio.aws.securityhub.model.UpdateInsightResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SecurityHub] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new SecurityHub {
          val api: SecurityHubAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : SecurityHub = this
          def getAdministratorAccount(
              request: GetAdministratorAccountRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly
          ] = proxy(GetAdministratorAccount, request)
          def batchEnableStandards(request: BatchEnableStandardsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly
          ] = proxy(BatchEnableStandards, request)
          def disableOrganizationAdminAccount(
              request: DisableOrganizationAdminAccountRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DisableOrganizationAdminAccountResponse.ReadOnly
          ] = proxy(DisableOrganizationAdminAccount, request)
          def getInsights(request: GetInsightsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.Insight.ReadOnly
          ] = rts.unsafeRun(proxy(GetInsights, request))
          def getInsightsPaginated(request: GetInsightsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.GetInsightsResponse.ReadOnly
          ] = proxy(GetInsightsPaginated, request)
          def listOrganizationAdminAccounts(
              request: ListOrganizationAdminAccountsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.AdminAccount.ReadOnly
          ] = rts.unsafeRun(proxy(ListOrganizationAdminAccounts, request))
          def listOrganizationAdminAccountsPaginated(
              request: ListOrganizationAdminAccountsRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly
          ] = proxy(ListOrganizationAdminAccountsPaginated, request)
          def updateFindingAggregator(
              request: UpdateFindingAggregatorRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly
          ] = proxy(UpdateFindingAggregator, request)
          def updateOrganizationConfiguration(
              request: UpdateOrganizationConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateOrganizationConfigurationResponse.ReadOnly
          ] = proxy(UpdateOrganizationConfiguration, request)
          def disableImportFindingsForProduct(
              request: DisableImportFindingsForProductRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DisableImportFindingsForProductResponse.ReadOnly
          ] = proxy(DisableImportFindingsForProduct, request)
          def getInvitationsCount(request: GetInvitationsCountRequest): IO[
            AwsError,
            zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly
          ] = proxy(GetInvitationsCount, request)
          def batchUpdateFindings(request: BatchUpdateFindingsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly
          ] = proxy(BatchUpdateFindings, request)
          def updateActionTarget(request: UpdateActionTargetRequest): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateActionTargetResponse.ReadOnly
          ] = proxy(UpdateActionTarget, request)
          def describeStandards(request: DescribeStandardsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.Standard.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeStandards, request))
          def describeStandardsPaginated(request: DescribeStandardsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly
          ] = proxy(DescribeStandardsPaginated, request)
          def disassociateMembers(
              request: DisassociateMembersRequest
          ): IO[AwsError, ReadOnly] = proxy(DisassociateMembers, request)
          def batchDisableStandards(request: BatchDisableStandardsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly
          ] = proxy(BatchDisableStandards, request)
          def deleteInsight(request: DeleteInsightRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DeleteInsightResponse.ReadOnly
          ] = proxy(DeleteInsight, request)
          def listMembers(
              request: ListMembersRequest
          ): ZStream[Any, AwsError, zio.aws.securityhub.model.Member.ReadOnly] =
            rts.unsafeRun(proxy(ListMembers, request))
          def listMembersPaginated(request: ListMembersRequest): IO[
            AwsError,
            zio.aws.securityhub.model.ListMembersResponse.ReadOnly
          ] = proxy(ListMembersPaginated, request)
          def enableImportFindingsForProduct(
              request: EnableImportFindingsForProductRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly
          ] = proxy(EnableImportFindingsForProduct, request)
          def describeProducts(request: DescribeProductsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.Product.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeProducts, request))
          def describeProductsPaginated(request: DescribeProductsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly
          ] = proxy(DescribeProductsPaginated, request)
          def createFindingAggregator(
              request: CreateFindingAggregatorRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.CreateFindingAggregatorResponse.ReadOnly
          ] = proxy(CreateFindingAggregator, request)
          def listEnabledProductsForImport(
              request: ListEnabledProductsForImportRequest
          ): ZStream[Any, AwsError, NonEmptyString] =
            rts.unsafeRun(proxy(ListEnabledProductsForImport, request))
          def listEnabledProductsForImportPaginated(
              request: ListEnabledProductsForImportRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly
          ] = proxy(ListEnabledProductsForImportPaginated, request)
          def inviteMembers(request: InviteMembersRequest): IO[
            AwsError,
            zio.aws.securityhub.model.InviteMembersResponse.ReadOnly
          ] = proxy(InviteMembers, request)
          def acceptAdministratorInvitation(
              request: AcceptAdministratorInvitationRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.AcceptAdministratorInvitationResponse.ReadOnly
          ] = proxy(AcceptAdministratorInvitation, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.securityhub.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def getFindings(request: GetFindingsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
          ] = rts.unsafeRun(proxy(GetFindings, request))
          def getFindingsPaginated(request: GetFindingsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.GetFindingsResponse.ReadOnly
          ] = proxy(GetFindingsPaginated, request)
          def updateFindings(request: UpdateFindingsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateFindingsResponse.ReadOnly
          ] = proxy(UpdateFindings, request)
          def createMembers(request: CreateMembersRequest): IO[
            AwsError,
            zio.aws.securityhub.model.CreateMembersResponse.ReadOnly
          ] = proxy(CreateMembers, request)
          def describeOrganizationConfiguration(
              request: DescribeOrganizationConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly
          ] = proxy(DescribeOrganizationConfiguration, request)
          def createActionTarget(request: CreateActionTargetRequest): IO[
            AwsError,
            zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly
          ] = proxy(CreateActionTarget, request)
          def createInsight(request: CreateInsightRequest): IO[
            AwsError,
            zio.aws.securityhub.model.CreateInsightResponse.ReadOnly
          ] = proxy(CreateInsight, request)
          def describeActionTargets(
              request: DescribeActionTargetsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.ActionTarget.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeActionTargets, request))
          def describeActionTargetsPaginated(
              request: DescribeActionTargetsRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly
          ] = proxy(DescribeActionTargetsPaginated, request)
          def enableSecurityHub(request: EnableSecurityHubRequest): IO[
            AwsError,
            zio.aws.securityhub.model.EnableSecurityHubResponse.ReadOnly
          ] = proxy(EnableSecurityHub, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.securityhub.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.securityhub.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def updateStandardsControl(
              request: UpdateStandardsControlRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateStandardsControlResponse.ReadOnly
          ] = proxy(UpdateStandardsControl, request)
          def listFindingAggregators(
              request: ListFindingAggregatorsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.FindingAggregator.ReadOnly
          ] = rts.unsafeRun(proxy(ListFindingAggregators, request))
          def listFindingAggregatorsPaginated(
              request: ListFindingAggregatorsRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly
          ] = proxy(ListFindingAggregatorsPaginated, request)
          def disableSecurityHub(request: DisableSecurityHubRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DisableSecurityHubResponse.ReadOnly
          ] = proxy(DisableSecurityHub, request)
          def listInvitations(request: ListInvitationsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.Invitation.ReadOnly
          ] = rts.unsafeRun(proxy(ListInvitations, request))
          def listInvitationsPaginated(request: ListInvitationsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly
          ] = proxy(ListInvitationsPaginated, request)
          def declineInvitations(request: DeclineInvitationsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DeclineInvitationsResponse.ReadOnly
          ] = proxy(DeclineInvitations, request)
          def getInsightResults(request: GetInsightResultsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.GetInsightResultsResponse.ReadOnly
          ] = proxy(GetInsightResults, request)
          def deleteFindingAggregator(
              request: DeleteFindingAggregatorRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DeleteFindingAggregatorResponse.ReadOnly
          ] = proxy(DeleteFindingAggregator, request)
          def describeStandardsControls(
              request: DescribeStandardsControlsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.StandardsControl.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeStandardsControls, request))
          def describeStandardsControlsPaginated(
              request: DescribeStandardsControlsRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly
          ] = proxy(DescribeStandardsControlsPaginated, request)
          def getFindingAggregator(request: GetFindingAggregatorRequest): IO[
            AwsError,
            zio.aws.securityhub.model.GetFindingAggregatorResponse.ReadOnly
          ] = proxy(GetFindingAggregator, request)
          def describeHub(request: DescribeHubRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DescribeHubResponse.ReadOnly
          ] = proxy(DescribeHub, request)
          def enableOrganizationAdminAccount(
              request: EnableOrganizationAdminAccountRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.EnableOrganizationAdminAccountResponse.ReadOnly
          ] = proxy(EnableOrganizationAdminAccount, request)
          def deleteInvitations(request: DeleteInvitationsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly
          ] = proxy(DeleteInvitations, request)
          def batchImportFindings(request: BatchImportFindingsRequest): IO[
            AwsError,
            zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly
          ] = proxy(BatchImportFindings, request)
          def getEnabledStandards(request: GetEnabledStandardsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.securityhub.model.StandardsSubscription.ReadOnly
          ] = rts.unsafeRun(proxy(GetEnabledStandards, request))
          def getEnabledStandardsPaginated(
              request: GetEnabledStandardsRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly
          ] = proxy(GetEnabledStandardsPaginated, request)
          def updateSecurityHubConfiguration(
              request: UpdateSecurityHubConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateSecurityHubConfigurationResponse.ReadOnly
          ] = proxy(UpdateSecurityHubConfiguration, request)
          def deleteMembers(request: DeleteMembersRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly
          ] = proxy(DeleteMembers, request)
          def disassociateFromAdministratorAccount(
              request: DisassociateFromAdministratorAccountRequest
          ): IO[
            AwsError,
            zio.aws.securityhub.model.DisassociateFromAdministratorAccountResponse.ReadOnly
          ] = proxy(DisassociateFromAdministratorAccount, request)
          def deleteActionTarget(request: DeleteActionTargetRequest): IO[
            AwsError,
            zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly
          ] = proxy(DeleteActionTarget, request)
          def getMembers(request: GetMembersRequest): IO[
            AwsError,
            zio.aws.securityhub.model.GetMembersResponse.ReadOnly
          ] = proxy(GetMembers, request)
          def updateInsight(request: UpdateInsightRequest): IO[
            AwsError,
            zio.aws.securityhub.model.UpdateInsightResponse.ReadOnly
          ] = proxy(UpdateInsight, request)
        }
      }
    }
    .toLayer
}
