package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StringFilter(
    value: Optional[NonEmptyString] = Optional.Absent,
    comparison: Optional[zio.aws.securityhub.model.StringFilterComparison] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StringFilter = {
    import StringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StringFilter
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(comparison.map(value => value.unwrap))(_.comparison)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StringFilter.ReadOnly =
    zio.aws.securityhub.model.StringFilter.wrap(buildAwsValue())
}
object StringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StringFilter =
      zio.aws.securityhub.model
        .StringFilter(value.map(value => value), comparison.map(value => value))
    def value: Optional[NonEmptyString]
    def comparison: Optional[zio.aws.securityhub.model.StringFilterComparison]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
    def getComparison
        : ZIO[Any, AwsError, zio.aws.securityhub.model.StringFilterComparison] =
      AwsError.unwrapOptionField("comparison", comparison)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StringFilter
  ) extends zio.aws.securityhub.model.StringFilter.ReadOnly {
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val comparison
        : Optional[zio.aws.securityhub.model.StringFilterComparison] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparison())
        .map(value =>
          zio.aws.securityhub.model.StringFilterComparison.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StringFilter
  ): zio.aws.securityhub.model.StringFilter.ReadOnly = new Wrapper(impl)
}
