package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRuleMatchAttributesSourcePorts(
    fromPort: Optional[Integer] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts = {
    import RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
      .builder()
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRuleMatchAttributesSourcePorts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts =
      zio.aws.securityhub.model
        .RuleGroupSourceStatelessRuleMatchAttributesSourcePorts(
          fromPort.map(value => value),
          toPort.map(value => value)
        )
    def fromPort: Optional[Integer]
    def toPort: Optional[Integer]
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.ReadOnly {
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.ReadOnly =
    new Wrapper(impl)
}
