package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRuleMatchAttributesDestinations(
    addressDefinition: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations = {
    import RuleGroupSourceStatelessRuleMatchAttributesDestinations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
      .builder()
      .optionallyWith(
        addressDefinition.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.addressDefinition)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRuleMatchAttributesDestinations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations =
      zio.aws.securityhub.model
        .RuleGroupSourceStatelessRuleMatchAttributesDestinations(
          addressDefinition.map(value => value)
        )
    def addressDefinition: Optional[NonEmptyString]
    def getAddressDefinition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("addressDefinition", addressDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.ReadOnly {
    override val addressDefinition: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressDefinition())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.ReadOnly =
    new Wrapper(impl)
}
