package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkPathComponent(
    componentId: Optional[NonEmptyString] = Optional.Absent,
    componentType: Optional[NonEmptyString] = Optional.Absent,
    egress: Optional[zio.aws.securityhub.model.NetworkHeader] = Optional.Absent,
    ingress: Optional[zio.aws.securityhub.model.NetworkHeader] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NetworkPathComponent = {
    import NetworkPathComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NetworkPathComponent
      .builder()
      .optionallyWith(
        componentId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(
        componentType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.componentType)
      .optionallyWith(egress.map(value => value.buildAwsValue()))(_.egress)
      .optionallyWith(ingress.map(value => value.buildAwsValue()))(_.ingress)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.NetworkPathComponent.ReadOnly =
    zio.aws.securityhub.model.NetworkPathComponent.wrap(buildAwsValue())
}
object NetworkPathComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NetworkPathComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NetworkPathComponent =
      zio.aws.securityhub.model.NetworkPathComponent(
        componentId.map(value => value),
        componentType.map(value => value),
        egress.map(value => value.asEditable),
        ingress.map(value => value.asEditable)
      )
    def componentId: Optional[NonEmptyString]
    def componentType: Optional[NonEmptyString]
    def egress: Optional[zio.aws.securityhub.model.NetworkHeader.ReadOnly]
    def ingress: Optional[zio.aws.securityhub.model.NetworkHeader.ReadOnly]
    def getComponentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getComponentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("componentType", componentType)
    def getEgress
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NetworkHeader.ReadOnly] =
      AwsError.unwrapOptionField("egress", egress)
    def getIngress
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NetworkHeader.ReadOnly] =
      AwsError.unwrapOptionField("ingress", ingress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkPathComponent
  ) extends zio.aws.securityhub.model.NetworkPathComponent.ReadOnly {
    override val componentId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val componentType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.componentType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val egress
        : Optional[zio.aws.securityhub.model.NetworkHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egress())
        .map(value => zio.aws.securityhub.model.NetworkHeader.wrap(value))
    override val ingress
        : Optional[zio.aws.securityhub.model.NetworkHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingress())
        .map(value => zio.aws.securityhub.model.NetworkHeader.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkPathComponent
  ): zio.aws.securityhub.model.NetworkPathComponent.ReadOnly = new Wrapper(impl)
}
