package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait MalwareType {
  def unwrap: software.amazon.awssdk.services.securityhub.model.MalwareType
}
object MalwareType {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.MalwareType
  ): zio.aws.securityhub.model.MalwareType = value match {
    case software.amazon.awssdk.services.securityhub.model.MalwareType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.ADWARE =>
      val r = ADWARE
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.BLENDED_THREAT =>
      val r = BLENDED_THREAT
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.BOTNET_AGENT =>
      val r = BOTNET_AGENT
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.COIN_MINER =>
      val r = COIN_MINER
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.EXPLOIT_KIT =>
      val r = EXPLOIT_KIT
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.KEYLOGGER =>
      val r = KEYLOGGER
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.MACRO =>
      val r = MACRO
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.POTENTIALLY_UNWANTED =>
      val r = POTENTIALLY_UNWANTED
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.SPYWARE =>
      val r = SPYWARE
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.RANSOMWARE =>
      val r = RANSOMWARE
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.REMOTE_ACCESS =>
      val r = REMOTE_ACCESS
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.ROOTKIT =>
      val r = ROOTKIT
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.TROJAN =>
      val r = TROJAN
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.VIRUS =>
      val r = VIRUS
      r
    case software.amazon.awssdk.services.securityhub.model.MalwareType.WORM =>
      val r = WORM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.UNKNOWN_TO_SDK_VERSION
  }
  case object ADWARE extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.ADWARE
  }
  case object BLENDED_THREAT extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.BLENDED_THREAT
  }
  case object BOTNET_AGENT extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.BOTNET_AGENT
  }
  case object COIN_MINER extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.COIN_MINER
  }
  case object EXPLOIT_KIT extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.EXPLOIT_KIT
  }
  case object KEYLOGGER extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.KEYLOGGER
  }
  case object MACRO extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.MACRO
  }
  case object POTENTIALLY_UNWANTED
      extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.POTENTIALLY_UNWANTED
  }
  case object SPYWARE extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.SPYWARE
  }
  case object RANSOMWARE extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.RANSOMWARE
  }
  case object REMOTE_ACCESS extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.REMOTE_ACCESS
  }
  case object ROOTKIT extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.ROOTKIT
  }
  case object TROJAN extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.TROJAN
  }
  case object VIRUS extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.VIRUS
  }
  case object WORM extends zio.aws.securityhub.model.MalwareType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.MalwareType =
      software.amazon.awssdk.services.securityhub.model.MalwareType.WORM
  }
}
