package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetInsightsRequest(
    insightArns: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetInsightsRequest = {
    import GetInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetInsightsRequest
      .builder()
      .optionallyWith(
        insightArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insightArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetInsightsRequest.ReadOnly =
    zio.aws.securityhub.model.GetInsightsRequest.wrap(buildAwsValue())
}
object GetInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetInsightsRequest =
      zio.aws.securityhub.model.GetInsightsRequest(
        insightArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def insightArns: Optional[List[NonEmptyString]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getInsightArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("insightArns", insightArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetInsightsRequest
  ) extends zio.aws.securityhub.model.GetInsightsRequest.ReadOnly {
    override val insightArns: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetInsightsRequest
  ): zio.aws.securityhub.model.GetInsightsRequest.ReadOnly = new Wrapper(impl)
}
