package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{NonEmptyString, RatioScale}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FindingProviderFields(
    confidence: Optional[RatioScale] = Optional.Absent,
    criticality: Optional[RatioScale] = Optional.Absent,
    relatedFindings: Optional[
      Iterable[zio.aws.securityhub.model.RelatedFinding]
    ] = Optional.Absent,
    severity: Optional[zio.aws.securityhub.model.FindingProviderSeverity] =
      Optional.Absent,
    types: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FindingProviderFields = {
    import FindingProviderFields.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FindingProviderFields
      .builder()
      .optionallyWith(
        confidence.map(value => RatioScale.unwrap(value): Integer)
      )(_.confidence)
      .optionallyWith(
        criticality.map(value => RatioScale.unwrap(value): Integer)
      )(_.criticality)
      .optionallyWith(
        relatedFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindings)
      .optionallyWith(severity.map(value => value.buildAwsValue()))(_.severity)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FindingProviderFields.ReadOnly =
    zio.aws.securityhub.model.FindingProviderFields.wrap(buildAwsValue())
}
object FindingProviderFields {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FindingProviderFields
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FindingProviderFields =
      zio.aws.securityhub.model.FindingProviderFields(
        confidence.map(value => value),
        criticality.map(value => value),
        relatedFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severity.map(value => value.asEditable),
        types.map(value => value)
      )
    def confidence: Optional[RatioScale]
    def criticality: Optional[RatioScale]
    def relatedFindings
        : Optional[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]]
    def severity
        : Optional[zio.aws.securityhub.model.FindingProviderSeverity.ReadOnly]
    def types: Optional[List[NonEmptyString]]
    def getConfidence: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("criticality", criticality)
    def getRelatedFindings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RelatedFinding.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindings", relatedFindings)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.FindingProviderSeverity.ReadOnly
    ] = AwsError.unwrapOptionField("severity", severity)
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FindingProviderFields
  ) extends zio.aws.securityhub.model.FindingProviderFields.ReadOnly {
    override val confidence: Optional[RatioScale] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val criticality: Optional[RatioScale] = zio.aws.core.internal
      .optionalFromNullable(impl.criticality())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val relatedFindings
        : Optional[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.RelatedFinding.wrap(item)
          }.toList
        )
    override val severity
        : Optional[zio.aws.securityhub.model.FindingProviderSeverity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value =>
          zio.aws.securityhub.model.FindingProviderSeverity.wrap(value)
        )
    override val types: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FindingProviderFields
  ): zio.aws.securityhub.model.FindingProviderFields.ReadOnly = new Wrapper(
    impl
  )
}
