package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdateFindingsResponse(
    processedFindings: Iterable[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier
    ],
    unprocessedFindings: Iterable[
      zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse = {
    import BatchUpdateFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse
      .builder()
      .processedFindings(processedFindings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .unprocessedFindings(unprocessedFindings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateFindingsResponse.wrap(buildAwsValue())
}
object BatchUpdateFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchUpdateFindingsResponse =
      zio.aws.securityhub.model.BatchUpdateFindingsResponse(
        processedFindings.map { item =>
          item.asEditable
        },
        unprocessedFindings.map { item =>
          item.asEditable
        }
      )
    def processedFindings
        : List[zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly]
    def unprocessedFindings: List[
      zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding.ReadOnly
    ]
    def getProcessedFindings: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ]] = ZIO.succeed(processedFindings)
    def getUnprocessedFindings: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding.ReadOnly
    ]] = ZIO.succeed(unprocessedFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse
  ) extends zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly {
    override val processedFindings: List[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ] = impl
      .processedFindings()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.AwsSecurityFindingIdentifier.wrap(item)
      }
      .toList
    override val unprocessedFindings: List[
      zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding.ReadOnly
    ] = impl
      .unprocessedFindings()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.BatchUpdateFindingsUnprocessedFinding
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse
  ): zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
