package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsXrayEncryptionConfigDetails(
    keyId: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails = {
    import AwsXrayEncryptionConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
      .builder()
      .optionallyWith(
        keyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails
      .wrap(buildAwsValue())
}
object AwsXrayEncryptionConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails =
      zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails(
        keyId.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def keyId: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def getKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
  ) extends zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly {
    override val keyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
  ): zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly =
    new Wrapper(impl)
}
