package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionTracingConfig(
    mode: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionTracingConfig = {
    import AwsLambdaFunctionTracingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionTracingConfig
      .builder()
      .optionallyWith(
        mode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.mode)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig
      .wrap(buildAwsValue())
}
object AwsLambdaFunctionTracingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionTracingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig =
      zio.aws.securityhub.model
        .AwsLambdaFunctionTracingConfig(mode.map(value => value))
    def mode: Optional[NonEmptyString]
    def getMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionTracingConfig
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly {
    override val mode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.mode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionTracingConfig
  ): zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly =
    new Wrapper(impl)
}
