package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamInstanceProfile(
    arn: Optional[NonEmptyString] = Optional.Absent,
    createDate: Optional[NonEmptyString] = Optional.Absent,
    instanceProfileId: Optional[NonEmptyString] = Optional.Absent,
    instanceProfileName: Optional[NonEmptyString] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    roles: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamInstanceProfileRole]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile = {
    import AwsIamInstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        instanceProfileId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceProfileId)
      .optionallyWith(
        instanceProfileName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceProfileName)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly =
    zio.aws.securityhub.model.AwsIamInstanceProfile.wrap(buildAwsValue())
}
object AwsIamInstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamInstanceProfile =
      zio.aws.securityhub.model.AwsIamInstanceProfile(
        arn.map(value => value),
        createDate.map(value => value),
        instanceProfileId.map(value => value),
        instanceProfileName.map(value => value),
        path.map(value => value),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[NonEmptyString]
    def createDate: Optional[NonEmptyString]
    def instanceProfileId: Optional[NonEmptyString]
    def instanceProfileName: Optional[NonEmptyString]
    def path: Optional[NonEmptyString]
    def roles: Optional[
      List[zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getInstanceProfileId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceProfileId", instanceProfileId)
    def getInstanceProfileName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly
    ]] = AwsError.unwrapOptionField("roles", roles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
  ) extends zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceProfileId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfileId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val instanceProfileName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfileName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roles: Optional[
      List[zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.roles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamInstanceProfileRole.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
  ): zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly = new Wrapper(
    impl
  )
}
