package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamAccessKeySessionContextAttributes(
    mfaAuthenticated: Optional[Boolean] = Optional.Absent,
    creationDate: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextAttributes = {
    import AwsIamAccessKeySessionContextAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextAttributes
      .builder()
      .optionallyWith(mfaAuthenticated.map(value => value: java.lang.Boolean))(
        _.mfaAuthenticated
      )
      .optionallyWith(
        creationDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes.ReadOnly =
    zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes
      .wrap(buildAwsValue())
}
object AwsIamAccessKeySessionContextAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes =
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes(
        mfaAuthenticated.map(value => value),
        creationDate.map(value => value)
      )
    def mfaAuthenticated: Optional[Boolean]
    def creationDate: Optional[NonEmptyString]
    def getMfaAuthenticated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mfaAuthenticated", mfaAuthenticated)
    def getCreationDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextAttributes
  ) extends zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes.ReadOnly {
    override val mfaAuthenticated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.mfaAuthenticated())
      .map(value => value: Boolean)
    override val creationDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextAttributes
  ): zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes.ReadOnly =
    new Wrapper(impl)
}
