package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerAttributes(
    accessLog: Optional[zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog] =
      Optional.Absent,
    connectionDraining: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining
    ] = Optional.Absent,
    connectionSettings: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings
    ] = Optional.Absent,
    crossZoneLoadBalancing: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAttributes = {
    import AwsElbLoadBalancerAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAttributes
      .builder()
      .optionallyWith(accessLog.map(value => value.buildAwsValue()))(
        _.accessLog
      )
      .optionallyWith(connectionDraining.map(value => value.buildAwsValue()))(
        _.connectionDraining
      )
      .optionallyWith(connectionSettings.map(value => value.buildAwsValue()))(
        _.connectionSettings
      )
      .optionallyWith(
        crossZoneLoadBalancing.map(value => value.buildAwsValue())
      )(_.crossZoneLoadBalancing)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.wrap(buildAwsValue())
}
object AwsElbLoadBalancerAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerAttributes =
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes(
        accessLog.map(value => value.asEditable),
        connectionDraining.map(value => value.asEditable),
        connectionSettings.map(value => value.asEditable),
        crossZoneLoadBalancing.map(value => value.asEditable)
      )
    def accessLog: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.ReadOnly
    ]
    def connectionDraining: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining.ReadOnly
    ]
    def connectionSettings: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly
    ]
    def crossZoneLoadBalancing: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.ReadOnly
    ]
    def getAccessLog: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.ReadOnly
    ] = AwsError.unwrapOptionField("accessLog", accessLog)
    def getConnectionDraining: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining.ReadOnly
    ] = AwsError.unwrapOptionField("connectionDraining", connectionDraining)
    def getConnectionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("connectionSettings", connectionSettings)
    def getCrossZoneLoadBalancing: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossZoneLoadBalancing",
      crossZoneLoadBalancing
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAttributes
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly {
    override val accessLog: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessLog())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.wrap(value)
      )
    override val connectionDraining: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionDraining())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining
          .wrap(value)
      )
    override val connectionSettings: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings
          .wrap(value)
      )
    override val crossZoneLoadBalancing: Optional[
      zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.crossZoneLoadBalancing())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAttributes
  ): zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly =
    new Wrapper(impl)
}
