package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceCapacityProviderStrategyDetails(
    base: Optional[Integer] = Optional.Absent,
    capacityProvider: Optional[NonEmptyString] = Optional.Absent,
    weight: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails = {
    import AwsEcsServiceCapacityProviderStrategyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
      .builder()
      .optionallyWith(base.map(value => value: java.lang.Integer))(_.base)
      .optionallyWith(
        capacityProvider.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.capacityProvider)
      .optionallyWith(weight.map(value => value: java.lang.Integer))(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceCapacityProviderStrategyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails =
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails(
        base.map(value => value),
        capacityProvider.map(value => value),
        weight.map(value => value)
      )
    def base: Optional[Integer]
    def capacityProvider: Optional[NonEmptyString]
    def weight: Optional[Integer]
    def getBase: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("base", base)
    def getCapacityProvider: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacityProvider", capacityProvider)
    def getWeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly {
    override val base: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.base())
      .map(value => value: Integer)
    override val capacityProvider: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProvider())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val weight: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.weight())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
  ): zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly =
    new Wrapper(impl)
}
