package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(
    cloudWatchEncryptionEnabled: Optional[Boolean] = Optional.Absent,
    cloudWatchLogGroupName: Optional[NonEmptyString] = Optional.Absent,
    s3BucketName: Optional[NonEmptyString] = Optional.Absent,
    s3EncryptionEnabled: Optional[Boolean] = Optional.Absent,
    s3KeyPrefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails = {
    import AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
      .builder()
      .optionallyWith(
        cloudWatchEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.cloudWatchEncryptionEnabled)
      .optionallyWith(
        cloudWatchLogGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupName)
      .optionallyWith(
        s3BucketName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3EncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.s3EncryptionEnabled)
      .optionallyWith(
        s3KeyPrefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(
          cloudWatchEncryptionEnabled.map(value => value),
          cloudWatchLogGroupName.map(value => value),
          s3BucketName.map(value => value),
          s3EncryptionEnabled.map(value => value),
          s3KeyPrefix.map(value => value)
        )
    def cloudWatchEncryptionEnabled: Optional[Boolean]
    def cloudWatchLogGroupName: Optional[NonEmptyString]
    def s3BucketName: Optional[NonEmptyString]
    def s3EncryptionEnabled: Optional[Boolean]
    def s3KeyPrefix: Optional[NonEmptyString]
    def getCloudWatchEncryptionEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "cloudWatchEncryptionEnabled",
        cloudWatchEncryptionEnabled
      )
    def getCloudWatchLogGroupName: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("cloudWatchLogGroupName", cloudWatchLogGroupName)
    def getS3BucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3EncryptionEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("s3EncryptionEnabled", s3EncryptionEnabled)
    def getS3KeyPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly {
    override val cloudWatchEncryptionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchEncryptionEnabled())
        .map(value => value: Boolean)
    override val cloudWatchLogGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val s3BucketName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3EncryptionEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.s3EncryptionEnabled())
      .map(value => value: Boolean)
    override val s3KeyPrefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
