package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupUserIdGroupPair(
    groupId: Optional[NonEmptyString] = Optional.Absent,
    groupName: Optional[NonEmptyString] = Optional.Absent,
    peeringStatus: Optional[NonEmptyString] = Optional.Absent,
    userId: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    vpcPeeringConnectionId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair = {
    import AwsEc2SecurityGroupUserIdGroupPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
      .builder()
      .optionallyWith(
        groupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        peeringStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.peeringStatus)
      .optionallyWith(
        userId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
      .wrap(buildAwsValue())
}
object AwsEc2SecurityGroupUserIdGroupPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair =
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair(
        groupId.map(value => value),
        groupName.map(value => value),
        peeringStatus.map(value => value),
        userId.map(value => value),
        vpcId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def groupId: Optional[NonEmptyString]
    def groupName: Optional[NonEmptyString]
    def peeringStatus: Optional[NonEmptyString]
    def userId: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def vpcPeeringConnectionId: Optional[NonEmptyString]
    def getGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getPeeringStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("peeringStatus", peeringStatus)
    def getUserId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userId", userId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly {
    override val groupId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val peeringStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.peeringStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcPeeringConnectionId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly =
    new Wrapper(impl)
}
