package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2EipDetails(
    instanceId: Optional[NonEmptyString] = Optional.Absent,
    publicIp: Optional[NonEmptyString] = Optional.Absent,
    allocationId: Optional[NonEmptyString] = Optional.Absent,
    associationId: Optional[NonEmptyString] = Optional.Absent,
    domain: Optional[NonEmptyString] = Optional.Absent,
    publicIpv4Pool: Optional[NonEmptyString] = Optional.Absent,
    networkBorderGroup: Optional[NonEmptyString] = Optional.Absent,
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent,
    networkInterfaceOwnerId: Optional[NonEmptyString] = Optional.Absent,
    privateIpAddress: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails = {
    import AwsEc2EipDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
      .builder()
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        publicIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.publicIp)
      .optionallyWith(
        allocationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.allocationId)
      .optionallyWith(
        associationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        domain.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        publicIpv4Pool.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicIpv4Pool)
      .optionallyWith(
        networkBorderGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkBorderGroup)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        networkInterfaceOwnerId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceOwnerId)
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2EipDetails.wrap(buildAwsValue())
}
object AwsEc2EipDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2EipDetails =
      zio.aws.securityhub.model.AwsEc2EipDetails(
        instanceId.map(value => value),
        publicIp.map(value => value),
        allocationId.map(value => value),
        associationId.map(value => value),
        domain.map(value => value),
        publicIpv4Pool.map(value => value),
        networkBorderGroup.map(value => value),
        networkInterfaceId.map(value => value),
        networkInterfaceOwnerId.map(value => value),
        privateIpAddress.map(value => value)
      )
    def instanceId: Optional[NonEmptyString]
    def publicIp: Optional[NonEmptyString]
    def allocationId: Optional[NonEmptyString]
    def associationId: Optional[NonEmptyString]
    def domain: Optional[NonEmptyString]
    def publicIpv4Pool: Optional[NonEmptyString]
    def networkBorderGroup: Optional[NonEmptyString]
    def networkInterfaceId: Optional[NonEmptyString]
    def networkInterfaceOwnerId: Optional[NonEmptyString]
    def privateIpAddress: Optional[NonEmptyString]
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPublicIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getAssociationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domain", domain)
    def getPublicIpv4Pool: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIpv4Pool", publicIpv4Pool)
    def getNetworkBorderGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkInterfaceOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "networkInterfaceOwnerId",
        networkInterfaceOwnerId
      )
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
  ) extends zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly {
    override val instanceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIp: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocationId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val associationId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domain: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIpv4Pool: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIpv4Pool())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val networkBorderGroup: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkBorderGroup())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val networkInterfaceOwnerId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceOwnerId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val privateIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
  ): zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly = new Wrapper(impl)
}
