package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionCacheBehaviors(
    items: Optional[
      Iterable[zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehaviors = {
    import AwsCloudFrontDistributionCacheBehaviors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionCacheBehaviors {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors =
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def items: Optional[List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior.ReadOnly
    ]]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors.ReadOnly {
    override val items: Optional[List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors.ReadOnly =
    new Wrapper(impl)
}
