package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateRenewalSummary(
    domainValidationOptions: Optional[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
    ]] = Optional.Absent,
    renewalStatus: Optional[NonEmptyString] = Optional.Absent,
    renewalStatusReason: Optional[NonEmptyString] = Optional.Absent,
    updatedAt: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary = {
    import AwsCertificateManagerCertificateRenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
      .builder()
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(
        renewalStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.renewalStatus)
      .optionallyWith(
        renewalStatusReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.renewalStatusReason)
      .optionallyWith(
        updatedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateRenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary =
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        renewalStatus.map(value => value),
        renewalStatusReason.map(value => value),
        updatedAt.map(value => value)
      )
    def domainValidationOptions: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]]
    def renewalStatus: Optional[NonEmptyString]
    def renewalStatusReason: Optional[NonEmptyString]
    def updatedAt: Optional[NonEmptyString]
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getRenewalStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("renewalStatus", renewalStatus)
    def getRenewalStatusReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("renewalStatusReason", renewalStatusReason)
    def getUpdatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly {
    override val domainValidationOptions: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
            .wrap(item)
        }.toList
      )
    override val renewalStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.renewalStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val renewalStatusReason: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renewalStatusReason())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val updatedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly =
    new Wrapper(impl)
}
