package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AvailabilityZone(
    zoneName: Optional[NonEmptyString] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AvailabilityZone
      .builder()
      .optionallyWith(
        zoneName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.zoneName)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AvailabilityZone.ReadOnly =
    zio.aws.securityhub.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AvailabilityZone =
      zio.aws.securityhub.model.AvailabilityZone(
        zoneName.map(value => value),
        subnetId.map(value => value)
      )
    def zoneName: Optional[NonEmptyString]
    def subnetId: Optional[NonEmptyString]
    def getZoneName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("zoneName", zoneName)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AvailabilityZone
  ) extends zio.aws.securityhub.model.AvailabilityZone.ReadOnly {
    override val zoneName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AvailabilityZone
  ): zio.aws.securityhub.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
