package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WafExcludedRule(ruleId: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.WafExcludedRule = {
    import WafExcludedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.WafExcludedRule
      .builder()
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.WafExcludedRule.ReadOnly =
    zio.aws.securityhub.model.WafExcludedRule.wrap(buildAwsValue())
}
object WafExcludedRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.WafExcludedRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.WafExcludedRule =
      zio.aws.securityhub.model.WafExcludedRule(ruleId.map(value => value))
    def ruleId: Option[NonEmptyString]
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.WafExcludedRule
  ) extends zio.aws.securityhub.model.WafExcludedRule.ReadOnly {
    override val ruleId: Option[NonEmptyString] = scala
      .Option(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.WafExcludedRule
  ): zio.aws.securityhub.model.WafExcludedRule.ReadOnly = new Wrapper(impl)
}
