package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Timestamp, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StandardsControl(
    standardsControlArn: Option[NonEmptyString] = None,
    controlStatus: Option[zio.aws.securityhub.model.ControlStatus] = None,
    disabledReason: Option[NonEmptyString] = None,
    controlStatusUpdatedAt: Option[Timestamp] = None,
    controlId: Option[NonEmptyString] = None,
    title: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    remediationUrl: Option[NonEmptyString] = None,
    severityRating: Option[zio.aws.securityhub.model.SeverityRating] = None,
    relatedRequirements: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsControl = {
    import StandardsControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsControl
      .builder()
      .optionallyWith(
        standardsControlArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsControlArn)
      .optionallyWith(controlStatus.map(value => value.unwrap))(_.controlStatus)
      .optionallyWith(
        disabledReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.disabledReason)
      .optionallyWith(
        controlStatusUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.controlStatusUpdatedAt)
      .optionallyWith(
        controlId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.controlId)
      .optionallyWith(
        title.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        remediationUrl.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.remediationUrl)
      .optionallyWith(severityRating.map(value => value.unwrap))(
        _.severityRating
      )
      .optionallyWith(
        relatedRequirements.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedRequirements)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StandardsControl.ReadOnly =
    zio.aws.securityhub.model.StandardsControl.wrap(buildAwsValue())
}
object StandardsControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsControl =
      zio.aws.securityhub.model.StandardsControl(
        standardsControlArn.map(value => value),
        controlStatus.map(value => value),
        disabledReason.map(value => value),
        controlStatusUpdatedAt.map(value => value),
        controlId.map(value => value),
        title.map(value => value),
        description.map(value => value),
        remediationUrl.map(value => value),
        severityRating.map(value => value),
        relatedRequirements.map(value => value)
      )
    def standardsControlArn: Option[NonEmptyString]
    def controlStatus: Option[zio.aws.securityhub.model.ControlStatus]
    def disabledReason: Option[NonEmptyString]
    def controlStatusUpdatedAt: Option[Timestamp]
    def controlId: Option[NonEmptyString]
    def title: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def remediationUrl: Option[NonEmptyString]
    def severityRating: Option[zio.aws.securityhub.model.SeverityRating]
    def relatedRequirements: Option[List[NonEmptyString]]
    def getStandardsControlArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsControlArn", standardsControlArn)
    def getControlStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.ControlStatus] =
      AwsError.unwrapOptionField("controlStatus", controlStatus)
    def getDisabledReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
    def getControlStatusUpdatedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("controlStatusUpdatedAt", controlStatusUpdatedAt)
    def getControlId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("controlId", controlId)
    def getTitle: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRemediationUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("remediationUrl", remediationUrl)
    def getSeverityRating
        : ZIO[Any, AwsError, zio.aws.securityhub.model.SeverityRating] =
      AwsError.unwrapOptionField("severityRating", severityRating)
    def getRelatedRequirements: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("relatedRequirements", relatedRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControl
  ) extends zio.aws.securityhub.model.StandardsControl.ReadOnly {
    override val standardsControlArn: Option[NonEmptyString] = scala
      .Option(impl.standardsControlArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val controlStatus
        : Option[zio.aws.securityhub.model.ControlStatus] = scala
      .Option(impl.controlStatus())
      .map(value => zio.aws.securityhub.model.ControlStatus.wrap(value))
    override val disabledReason: Option[NonEmptyString] = scala
      .Option(impl.disabledReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val controlStatusUpdatedAt: Option[Timestamp] = scala
      .Option(impl.controlStatusUpdatedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val controlId: Option[NonEmptyString] = scala
      .Option(impl.controlId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val title: Option[NonEmptyString] = scala
      .Option(impl.title())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val remediationUrl: Option[NonEmptyString] = scala
      .Option(impl.remediationUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val severityRating
        : Option[zio.aws.securityhub.model.SeverityRating] = scala
      .Option(impl.severityRating())
      .map(value => zio.aws.securityhub.model.SeverityRating.wrap(value))
    override val relatedRequirements: Option[List[NonEmptyString]] = scala
      .Option(impl.relatedRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControl
  ): zio.aws.securityhub.model.StandardsControl.ReadOnly = new Wrapper(impl)
}
