package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupDetails(
    ruleVariables: Option[zio.aws.securityhub.model.RuleGroupVariables] = None,
    rulesSource: Option[zio.aws.securityhub.model.RuleGroupSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupDetails = {
    import RuleGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupDetails
      .builder()
      .optionallyWith(ruleVariables.map(value => value.buildAwsValue()))(
        _.ruleVariables
      )
      .optionallyWith(rulesSource.map(value => value.buildAwsValue()))(
        _.rulesSource
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RuleGroupDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupDetails.wrap(buildAwsValue())
}
object RuleGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupDetails =
      zio.aws.securityhub.model.RuleGroupDetails(
        ruleVariables.map(value => value.asEditable),
        rulesSource.map(value => value.asEditable)
      )
    def ruleVariables
        : Option[zio.aws.securityhub.model.RuleGroupVariables.ReadOnly]
    def rulesSource: Option[zio.aws.securityhub.model.RuleGroupSource.ReadOnly]
    def getRuleVariables: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupVariables.ReadOnly
    ] = AwsError.unwrapOptionField("ruleVariables", ruleVariables)
    def getRulesSource: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSource.ReadOnly
    ] = AwsError.unwrapOptionField("rulesSource", rulesSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupDetails
  ) extends zio.aws.securityhub.model.RuleGroupDetails.ReadOnly {
    override val ruleVariables
        : Option[zio.aws.securityhub.model.RuleGroupVariables.ReadOnly] = scala
      .Option(impl.ruleVariables())
      .map(value => zio.aws.securityhub.model.RuleGroupVariables.wrap(value))
    override val rulesSource
        : Option[zio.aws.securityhub.model.RuleGroupSource.ReadOnly] = scala
      .Option(impl.rulesSource())
      .map(value => zio.aws.securityhub.model.RuleGroupSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupDetails
  ): zio.aws.securityhub.model.RuleGroupDetails.ReadOnly = new Wrapper(impl)
}
