package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Resource(
    `type`: NonEmptyString,
    id: NonEmptyString,
    partition: Option[zio.aws.securityhub.model.Partition] = None,
    region: Option[NonEmptyString] = None,
    resourceRole: Option[NonEmptyString] = None,
    tags: Option[Map[NonEmptyString, NonEmptyString]] = None,
    dataClassification: Option[
      zio.aws.securityhub.model.DataClassificationDetails
    ] = None,
    details: Option[zio.aws.securityhub.model.ResourceDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Resource
      .builder()
      .`type`(NonEmptyString.unwrap(`type`): java.lang.String)
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(partition.map(value => value.unwrap))(_.partition)
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        resourceRole.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceRole)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(dataClassification.map(value => value.buildAwsValue()))(
        _.dataClassification
      )
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Resource.ReadOnly =
    zio.aws.securityhub.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Resource =
      zio.aws.securityhub.model.Resource(
        `type`,
        id,
        partition.map(value => value),
        region.map(value => value),
        resourceRole.map(value => value),
        tags.map(value => value),
        dataClassification.map(value => value.asEditable),
        details.map(value => value.asEditable)
      )
    def `type`: NonEmptyString
    def id: NonEmptyString
    def partition: Option[zio.aws.securityhub.model.Partition]
    def region: Option[NonEmptyString]
    def resourceRole: Option[NonEmptyString]
    def tags: Option[Map[NonEmptyString, NonEmptyString]]
    def dataClassification
        : Option[zio.aws.securityhub.model.DataClassificationDetails.ReadOnly]
    def details: Option[zio.aws.securityhub.model.ResourceDetails.ReadOnly]
    def getType: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(`type`)
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getPartition: ZIO[Any, AwsError, zio.aws.securityhub.model.Partition] =
      AwsError.unwrapOptionField("partition", partition)
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getResourceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceRole", resourceRole)
    def getTags: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDataClassification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.DataClassificationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("dataClassification", dataClassification)
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ResourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Resource
  ) extends zio.aws.securityhub.model.Resource.ReadOnly {
    override val `type`: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.`type`())
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val partition: Option[zio.aws.securityhub.model.Partition] = scala
      .Option(impl.partition())
      .map(value => zio.aws.securityhub.model.Partition.wrap(value))
    override val region: Option[NonEmptyString] = scala
      .Option(impl.region())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceRole: Option[NonEmptyString] = scala
      .Option(impl.resourceRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tags: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val dataClassification
        : Option[zio.aws.securityhub.model.DataClassificationDetails.ReadOnly] =
      scala
        .Option(impl.dataClassification())
        .map(value =>
          zio.aws.securityhub.model.DataClassificationDetails.wrap(value)
        )
    override val details
        : Option[zio.aws.securityhub.model.ResourceDetails.ReadOnly] = scala
      .Option(impl.details())
      .map(value => zio.aws.securityhub.model.ResourceDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Resource
  ): zio.aws.securityhub.model.Resource.ReadOnly = new Wrapper(impl)
}
