package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PortRangeFromTo(
    from: Option[Integer] = None,
    to: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PortRangeFromTo = {
    import PortRangeFromTo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PortRangeFromTo
      .builder()
      .optionallyWith(from.map(value => value: java.lang.Integer))(_.from)
      .optionallyWith(to.map(value => value: java.lang.Integer))(_.to)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PortRangeFromTo.ReadOnly =
    zio.aws.securityhub.model.PortRangeFromTo.wrap(buildAwsValue())
}
object PortRangeFromTo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PortRangeFromTo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PortRangeFromTo =
      zio.aws.securityhub.model
        .PortRangeFromTo(from.map(value => value), to.map(value => value))
    def from: Option[Integer]
    def to: Option[Integer]
    def getFrom: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("to", to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PortRangeFromTo
  ) extends zio.aws.securityhub.model.PortRangeFromTo.ReadOnly {
    override val from: Option[Integer] =
      scala.Option(impl.from()).map(value => value: Integer)
    override val to: Option[Integer] =
      scala.Option(impl.to()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PortRangeFromTo
  ): zio.aws.securityhub.model.PortRangeFromTo.ReadOnly = new Wrapper(impl)
}
