package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PortRange(
    begin: Option[Integer] = None,
    end: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PortRange
      .builder()
      .optionallyWith(begin.map(value => value: java.lang.Integer))(_.begin)
      .optionallyWith(end.map(value => value: java.lang.Integer))(_.end)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PortRange.ReadOnly =
    zio.aws.securityhub.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PortRange =
      zio.aws.securityhub.model
        .PortRange(begin.map(value => value), end.map(value => value))
    def begin: Option[Integer]
    def end: Option[Integer]
    def getBegin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("begin", begin)
    def getEnd: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("end", end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PortRange
  ) extends zio.aws.securityhub.model.PortRange.ReadOnly {
    override val begin: Option[Integer] =
      scala.Option(impl.begin()).map(value => value: Integer)
    override val end: Option[Integer] =
      scala.Option(impl.end()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PortRange
  ): zio.aws.securityhub.model.PortRange.ReadOnly = new Wrapper(impl)
}
