package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Page(
    pageNumber: Option[Long] = None,
    lineRange: Option[zio.aws.securityhub.model.Range] = None,
    offsetRange: Option[zio.aws.securityhub.model.Range] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Page = {
    import Page.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Page
      .builder()
      .optionallyWith(pageNumber.map(value => value: java.lang.Long))(
        _.pageNumber
      )
      .optionallyWith(lineRange.map(value => value.buildAwsValue()))(
        _.lineRange
      )
      .optionallyWith(offsetRange.map(value => value.buildAwsValue()))(
        _.offsetRange
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Page.ReadOnly =
    zio.aws.securityhub.model.Page.wrap(buildAwsValue())
}
object Page {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Page] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Page =
      zio.aws.securityhub.model.Page(
        pageNumber.map(value => value),
        lineRange.map(value => value.asEditable),
        offsetRange.map(value => value.asEditable)
      )
    def pageNumber: Option[Long]
    def lineRange: Option[zio.aws.securityhub.model.Range.ReadOnly]
    def offsetRange: Option[zio.aws.securityhub.model.Range.ReadOnly]
    def getPageNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
    def getLineRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("lineRange", lineRange)
    def getOffsetRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("offsetRange", offsetRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Page
  ) extends zio.aws.securityhub.model.Page.ReadOnly {
    override val pageNumber: Option[Long] =
      scala.Option(impl.pageNumber()).map(value => value: Long)
    override val lineRange: Option[zio.aws.securityhub.model.Range.ReadOnly] =
      scala
        .Option(impl.lineRange())
        .map(value => zio.aws.securityhub.model.Range.wrap(value))
    override val offsetRange: Option[zio.aws.securityhub.model.Range.ReadOnly] =
      scala
        .Option(impl.offsetRange())
        .map(value => zio.aws.securityhub.model.Range.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Page
  ): zio.aws.securityhub.model.Page.ReadOnly = new Wrapper(impl)
}
