package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Occurrences(
    lineRanges: Option[Iterable[zio.aws.securityhub.model.Range]] = None,
    offsetRanges: Option[Iterable[zio.aws.securityhub.model.Range]] = None,
    pages: Option[Iterable[zio.aws.securityhub.model.Page]] = None,
    records: Option[Iterable[zio.aws.securityhub.model.Record]] = None,
    cells: Option[Iterable[zio.aws.securityhub.model.Cell]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Occurrences = {
    import Occurrences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Occurrences
      .builder()
      .optionallyWith(
        lineRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineRanges)
      .optionallyWith(
        offsetRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offsetRanges)
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pages)
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .optionallyWith(
        cells.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cells)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Occurrences.ReadOnly =
    zio.aws.securityhub.model.Occurrences.wrap(buildAwsValue())
}
object Occurrences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Occurrences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Occurrences =
      zio.aws.securityhub.model.Occurrences(
        lineRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        offsetRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cells.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lineRanges: Option[List[zio.aws.securityhub.model.Range.ReadOnly]]
    def offsetRanges: Option[List[zio.aws.securityhub.model.Range.ReadOnly]]
    def pages: Option[List[zio.aws.securityhub.model.Page.ReadOnly]]
    def records: Option[List[zio.aws.securityhub.model.Record.ReadOnly]]
    def cells: Option[List[zio.aws.securityhub.model.Cell.ReadOnly]]
    def getLineRanges
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("lineRanges", lineRanges)
    def getOffsetRanges
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("offsetRanges", offsetRanges)
    def getPages
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Page.ReadOnly]] =
      AwsError.unwrapOptionField("pages", pages)
    def getRecords
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Record.ReadOnly]] =
      AwsError.unwrapOptionField("records", records)
    def getCells
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Cell.ReadOnly]] =
      AwsError.unwrapOptionField("cells", cells)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Occurrences
  ) extends zio.aws.securityhub.model.Occurrences.ReadOnly {
    override val lineRanges
        : Option[List[zio.aws.securityhub.model.Range.ReadOnly]] = scala
      .Option(impl.lineRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Range.wrap(item)
        }.toList
      )
    override val offsetRanges
        : Option[List[zio.aws.securityhub.model.Range.ReadOnly]] = scala
      .Option(impl.offsetRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Range.wrap(item)
        }.toList
      )
    override val pages: Option[List[zio.aws.securityhub.model.Page.ReadOnly]] =
      scala
        .Option(impl.pages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Page.wrap(item)
          }.toList
        )
    override val records
        : Option[List[zio.aws.securityhub.model.Record.ReadOnly]] = scala
      .Option(impl.records())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Record.wrap(item)
        }.toList
      )
    override val cells: Option[List[zio.aws.securityhub.model.Cell.ReadOnly]] =
      scala
        .Option(impl.cells())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Cell.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Occurrences
  ): zio.aws.securityhub.model.Occurrences.ReadOnly = new Wrapper(impl)
}
