package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkHeader(
    protocol: Option[NonEmptyString] = None,
    destination: Option[zio.aws.securityhub.model.NetworkPathComponentDetails] =
      None,
    source: Option[zio.aws.securityhub.model.NetworkPathComponentDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NetworkHeader = {
    import NetworkHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NetworkHeader
      .builder()
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.NetworkHeader.ReadOnly =
    zio.aws.securityhub.model.NetworkHeader.wrap(buildAwsValue())
}
object NetworkHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NetworkHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NetworkHeader =
      zio.aws.securityhub.model.NetworkHeader(
        protocol.map(value => value),
        destination.map(value => value.asEditable),
        source.map(value => value.asEditable)
      )
    def protocol: Option[NonEmptyString]
    def destination
        : Option[zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly]
    def source
        : Option[zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly]
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkHeader
  ) extends zio.aws.securityhub.model.NetworkHeader.ReadOnly {
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destination: Option[
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = scala
      .Option(impl.destination())
      .map(value =>
        zio.aws.securityhub.model.NetworkPathComponentDetails.wrap(value)
      )
    override val source: Option[
      zio.aws.securityhub.model.NetworkPathComponentDetails.ReadOnly
    ] = scala
      .Option(impl.source())
      .map(value =>
        zio.aws.securityhub.model.NetworkPathComponentDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NetworkHeader
  ): zio.aws.securityhub.model.NetworkHeader.ReadOnly = new Wrapper(impl)
}
