package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait NetworkDirection {
  def unwrap: software.amazon.awssdk.services.securityhub.model.NetworkDirection
}
object NetworkDirection {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.NetworkDirection
  ): zio.aws.securityhub.model.NetworkDirection = value match {
    case software.amazon.awssdk.services.securityhub.model.NetworkDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.NetworkDirection.IN =>
      val r = IN
      r
    case software.amazon.awssdk.services.securityhub.model.NetworkDirection.OUT =>
      val r = OUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.NetworkDirection {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.NetworkDirection =
      software.amazon.awssdk.services.securityhub.model.NetworkDirection.UNKNOWN_TO_SDK_VERSION
  }
  case object IN extends zio.aws.securityhub.model.NetworkDirection {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.NetworkDirection =
      software.amazon.awssdk.services.securityhub.model.NetworkDirection.IN
  }
  case object OUT extends zio.aws.securityhub.model.NetworkDirection {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.NetworkDirection =
      software.amazon.awssdk.services.securityhub.model.NetworkDirection.OUT
  }
}
