package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Malware(
    name: NonEmptyString,
    `type`: Option[zio.aws.securityhub.model.MalwareType] = None,
    path: Option[NonEmptyString] = None,
    state: Option[zio.aws.securityhub.model.MalwareState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Malware = {
    import Malware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Malware
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Malware.ReadOnly =
    zio.aws.securityhub.model.Malware.wrap(buildAwsValue())
}
object Malware {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Malware
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Malware =
      zio.aws.securityhub.model.Malware(
        name,
        `type`.map(value => value),
        path.map(value => value),
        state.map(value => value)
      )
    def name: NonEmptyString
    def `type`: Option[zio.aws.securityhub.model.MalwareType]
    def path: Option[NonEmptyString]
    def state: Option[zio.aws.securityhub.model.MalwareState]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getType: ZIO[Any, AwsError, zio.aws.securityhub.model.MalwareType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getState: ZIO[Any, AwsError, zio.aws.securityhub.model.MalwareState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Malware
  ) extends zio.aws.securityhub.model.Malware.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.name())
    override val `type`: Option[zio.aws.securityhub.model.MalwareType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.MalwareType.wrap(value))
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Option[zio.aws.securityhub.model.MalwareState] = scala
      .Option(impl.state())
      .map(value => zio.aws.securityhub.model.MalwareState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Malware
  ): zio.aws.securityhub.model.Malware.ReadOnly = new Wrapper(impl)
}
