package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAdministratorAccountResponse(
    administrator: Option[zio.aws.securityhub.model.Invitation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse = {
    import GetAdministratorAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse
      .builder()
      .optionallyWith(administrator.map(value => value.buildAwsValue()))(
        _.administrator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly =
    zio.aws.securityhub.model.GetAdministratorAccountResponse
      .wrap(buildAwsValue())
}
object GetAdministratorAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetAdministratorAccountResponse =
      zio.aws.securityhub.model.GetAdministratorAccountResponse(
        administrator.map(value => value.asEditable)
      )
    def administrator: Option[zio.aws.securityhub.model.Invitation.ReadOnly]
    def getAdministrator
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Invitation.ReadOnly] =
      AwsError.unwrapOptionField("administrator", administrator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse
  ) extends zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly {
    override val administrator
        : Option[zio.aws.securityhub.model.Invitation.ReadOnly] = scala
      .Option(impl.administrator())
      .map(value => zio.aws.securityhub.model.Invitation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse
  ): zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly =
    new Wrapper(impl)
}
