package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FirewallPolicyStatelessRuleGroupReferencesDetails(
    priority: Option[Integer] = None,
    resourceArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails = {
    import FirewallPolicyStatelessRuleGroupReferencesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
      .builder()
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(
        resourceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly =
    zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
      .wrap(buildAwsValue())
}
object FirewallPolicyStatelessRuleGroupReferencesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails =
      zio.aws.securityhub.model
        .FirewallPolicyStatelessRuleGroupReferencesDetails(
          priority.map(value => value),
          resourceArn.map(value => value)
        )
    def priority: Option[Integer]
    def resourceArn: Option[NonEmptyString]
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
  ) extends zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly {
    override val priority: Option[Integer] =
      scala.Option(impl.priority()).map(value => value: Integer)
    override val resourceArn: Option[NonEmptyString] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
  ): zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly =
    new Wrapper(impl)
}
