package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStandardsControlsResponse(
    controls: Option[Iterable[zio.aws.securityhub.model.StandardsControl]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse = {
    import DescribeStandardsControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse
      .builder()
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controls)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeStandardsControlsResponse
      .wrap(buildAwsValue())
}
object DescribeStandardsControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.DescribeStandardsControlsResponse =
      zio.aws.securityhub.model.DescribeStandardsControlsResponse(
        controls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def controls
        : Option[List[zio.aws.securityhub.model.StandardsControl.ReadOnly]]
    def nextToken: Option[NextToken]
    def getControls: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StandardsControl.ReadOnly
    ]] = AwsError.unwrapOptionField("controls", controls)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse
  ) extends zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly {
    override val controls
        : Option[List[zio.aws.securityhub.model.StandardsControl.ReadOnly]] =
      scala
        .Option(impl.controls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StandardsControl.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse
  ): zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly =
    new Wrapper(impl)
}
