package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsSecretsManagerSecretRotationRules(
    automaticallyAfterDays: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretRotationRules = {
    import AwsSecretsManagerSecretRotationRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretRotationRules
      .builder()
      .optionallyWith(
        automaticallyAfterDays.map(value => value: java.lang.Integer)
      )(_.automaticallyAfterDays)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly =
    zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules
      .wrap(buildAwsValue())
}
object AwsSecretsManagerSecretRotationRules {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretRotationRules
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules =
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules(
        automaticallyAfterDays.map(value => value)
      )
    def automaticallyAfterDays: Option[Integer]
    def getAutomaticallyAfterDays: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("automaticallyAfterDays", automaticallyAfterDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretRotationRules
  ) extends zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly {
    override val automaticallyAfterDays: Option[Integer] =
      scala.Option(impl.automaticallyAfterDays()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretRotationRules
  ): zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly =
    new Wrapper(impl)
}
