package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfigurationRoutingRuleRedirect(
    hostname: Option[NonEmptyString] = None,
    httpRedirectCode: Option[NonEmptyString] = None,
    protocol: Option[NonEmptyString] = None,
    replaceKeyPrefixWith: Option[NonEmptyString] = None,
    replaceKeyWith: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect = {
    import AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
      .builder()
      .optionallyWith(
        hostname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        httpRedirectCode.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpRedirectCode)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        replaceKeyPrefixWith.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replaceKeyPrefixWith)
      .optionallyWith(
        replaceKeyWith.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replaceKeyWith)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfigurationRoutingRuleRedirect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect =
      zio.aws.securityhub.model
        .AwsS3BucketWebsiteConfigurationRoutingRuleRedirect(
          hostname.map(value => value),
          httpRedirectCode.map(value => value),
          protocol.map(value => value),
          replaceKeyPrefixWith.map(value => value),
          replaceKeyWith.map(value => value)
        )
    def hostname: Option[NonEmptyString]
    def httpRedirectCode: Option[NonEmptyString]
    def protocol: Option[NonEmptyString]
    def replaceKeyPrefixWith: Option[NonEmptyString]
    def replaceKeyWith: Option[NonEmptyString]
    def getHostname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getHttpRedirectCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpRedirectCode", httpRedirectCode)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getReplaceKeyPrefixWith: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("replaceKeyPrefixWith", replaceKeyPrefixWith)
    def getReplaceKeyWith: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("replaceKeyWith", replaceKeyWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly {
    override val hostname: Option[NonEmptyString] = scala
      .Option(impl.hostname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpRedirectCode: Option[NonEmptyString] = scala
      .Option(impl.httpRedirectCode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replaceKeyPrefixWith: Option[NonEmptyString] = scala
      .Option(impl.replaceKeyPrefixWith())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replaceKeyWith: Option[NonEmptyString] = scala
      .Option(impl.replaceKeyWith())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.ReadOnly =
    new Wrapper(impl)
}
